library(DESeq2)
library(ggplot2)
library(ggrepel)
library(pheatmap)
args=commandArgs(T)
file <- args[1]
file1 <- args[2]
file2 <- args[3]
file3 <- args[4]
count.data <- read.csv(file,header = T)
exp.data <- count.data[,-1*1:6]
rownames(exp.data) <- count.data[,1]
colnames(exp.data) <- gsub(".R1.new.sam", "", colnames(exp.data))
mycounts <- exp.data
condition<- factor(c(rep("control1",2),rep("control2",2),rep("treat1",2),rep("treat2",2)))
colData <- data.frame(names = c("control-6h-1","control-6h-2","control-12h-1","control-12h-2","COVID-6h-1","COVID-6h-2","COVID-12h-1","COVID-12h-2"),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=8
dds <- dds[keep,]
dds_norm <- DESeq(dds)


#rld <- rlog(dds)
#plotPCA(rld,intgroup=c("condition","names"))
#pcaData <- plotPCA(rld,intgroup=c("condition","names"),returnData=T)
#percentVar <- round(100*attr(pcaData,"percentVar"))
#pca <- ggplot(pcaData,aes(PC1,PC2,color=names,shape=condition))+geom_point(size=3)+ggtitle("DESeq2 PCA")+xlab(paste0("PC1:",percentVar[1],"% variance"))+ylab(paste0("PC2:", percentVar[2],"% variance"))+theme_bw()
#pca



mycounts <- exp.data[,c(1,2,5,6)]
condition<- factor(c(rep("control",2),rep("treat",2)))
colData <- data.frame(names = colnames(mycounts),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=4
dds <- dds[keep,]
dds_norm <- DESeq(dds)

contrast <- c("condition","treat","control")
res <- results(dds_norm,contrast = contrast)
res$change <-  ifelse(res$padj <= 0.05& abs(res$log2FoldChange)>= 0.58, ifelse(res$log2FoldChange >=0.58 ,'Up','Down'), 'Stable')
res$name <- rownames(res)
res <- as.data.frame(res)
p <- ggplot(data = res, aes(x = log2FoldChange, y = -log10(padj), colour=change)) +geom_point() +scale_color_manual(values=c("blue", "grey","red"))+xlim(c(-7.5, 7.5)) +geom_vline(xintercept=c(-0.58,0.58),lty=4,col="black",lwd=0.6) +geom_hline(yintercept = -log10(0.05),lty=4,col="black",lwd=0.6) +labs(x="log2(fold change)",y="-log10 (padj)") +theme_bw()+theme(plot.title = element_text(hjust = 0.5), legend.position="right")+geom_text_repel(data=res[res$padj<=0.05&abs(res$log2FoldChange)>=0.58,],aes(label=name),size=3,segment.color="black",show.legend = F)+ylim(0,10)
p
covid6 <- p
pdf(file1,width=8,height=8)
covid6
dev.off()
res1 <- res



mycounts <- exp.data[,c(3,4,7,8)]
condition<- factor(c(rep("control",2),rep("treat",2)))
colData <- data.frame(names = colnames(mycounts),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=4
dds <- dds[keep,]
dds_norm <- DESeq(dds)

contrast <- c("condition","treat","control")
res <- results(dds_norm,contrast = contrast)
res$change <-  ifelse(res$padj <= 0.05& abs(res$log2FoldChange)>= 0.58, ifelse(res$log2FoldChange >=0.58 ,'Up','Down'), 'Stable')
res$name <- rownames(res)
res <- as.data.frame(res)
p <- ggplot(data = res, aes(x = log2FoldChange, y = -log10(padj), colour=change)) +geom_point() +scale_color_manual(values=c("blue", "grey","red"))+xlim(c(-7.5, 7.5)) +geom_vline(xintercept=c(-0.58,0.58),lty=4,col="black",lwd=0.6) +geom_hline(yintercept = -log10(0.05),lty=4,col="black",lwd=0.6) +labs(x="log2(fold change)",y="-log10 (padj)") +theme_bw()+theme(plot.title = element_text(hjust = 0.5), legend.position="right")+geom_text_repel(data=res[res$padj<=0.05&abs(res$log2FoldChange)>=0.58,],aes(label=name),size=3,segment.color="black",show.legend = F)
p

pdf(file2,width=8,height=8)
p
dev.off()

b <- rownames(subset(res,res$padj<=0.05&abs(res$log2FoldChange)>=0.58))
a <- rownames(subset(res1,res1$padj<=0.05&abs(res1$log2FoldChange)>=0.58))
test <- append(a,b)
result1 <- exp.data[test,]
result2 <- res[test,c(2,6,7)]
result3 <- res1[test,c(2,6,7,8)]

temp <- append(result2,result3)
temp <- append(temp,result1)
temp <- as.data.frame(temp)
temp$B2_cpm=temp$B2_L1_I333*10^6/16573117
temp$B3_cpm=temp$B3_L1_I334*10^6/17853053
temp$B5_cpm=temp$B5_L1_I336*10^6/16776155
temp$B6_cpm=temp$B6_L1_I337*10^6/15479642
temp$B10_cpm=temp$B10_L1_I343*10^6/14183670
temp$B12_cpm=temp$B12_L1_I345*10^6/17662919
temp$B14_cpm=temp$B14_L1_I347*10^6/17568431
temp$B15_cpm=temp$B15_L1_I348*10^6/23858609

temp <- temp[,c(7,8,9,12,13,16,17,20,21,4,5,6,10,11,14,15,18,19,22,23)]

write.csv(temp,file=file3,row.names = F)




#condition<- factor(c(rep("control1",2),rep("control2",2),rep("treat1",2),rep("treat2",2)))
#colData <- data.frame(names = c("control-6h-1","control-6h-2","control-12h-1","control-12h-2","COVID-6h-1","COVID-6h-2","COVID-12h-1","COVID-12h-2"),condition)
#rownames(colData) = colnames(exp.data)
#result1 <- result1[-30,c(1,2,5,6,3,4,7,8)]
#choose_gene <- t(scale(t(result1)))
#pheatmap(choose_gene,show_rownames = T,show_colnames = T,annotation_col = colData,cluster_cols = F,cluster_rows = T)
